// modules are defined as an array
// [ module function, map of requires ]
//
// map of requires is short require name -> numeric require
//
// anything defined in a previous bundle is accessed via the
// orig method which is the require for previous bundles

(function (modules, entry, mainEntry, parcelRequireName, globalName) {
  /* eslint-disable no-undef */
  var globalObject =
    typeof globalThis !== 'undefined'
      ? globalThis
      : typeof self !== 'undefined'
      ? self
      : typeof window !== 'undefined'
      ? window
      : typeof global !== 'undefined'
      ? global
      : {};
  /* eslint-enable no-undef */

  // Save the require from previous bundle to this closure if any
  var previousRequire =
    typeof globalObject[parcelRequireName] === 'function' &&
    globalObject[parcelRequireName];

  var cache = previousRequire.cache || {};
  // Do not use `require` to prevent Webpack from trying to bundle this call
  var nodeRequire =
    typeof module !== 'undefined' &&
    typeof module.require === 'function' &&
    module.require.bind(module);

  function newRequire(name, jumped) {
    if (!cache[name]) {
      if (!modules[name]) {
        // if we cannot find the module within our internal map or
        // cache jump to the current global require ie. the last bundle
        // that was added to the page.
        var currentRequire =
          typeof globalObject[parcelRequireName] === 'function' &&
          globalObject[parcelRequireName];
        if (!jumped && currentRequire) {
          return currentRequire(name, true);
        }

        // If there are other bundles on this page the require from the
        // previous one is saved to 'previousRequire'. Repeat this as
        // many times as there are bundles until the module is found or
        // we exhaust the require chain.
        if (previousRequire) {
          return previousRequire(name, true);
        }

        // Try the node require function if it exists.
        if (nodeRequire && typeof name === 'string') {
          return nodeRequire(name);
        }

        var err = new Error("Cannot find module '" + name + "'");
        err.code = 'MODULE_NOT_FOUND';
        throw err;
      }

      localRequire.resolve = resolve;
      localRequire.cache = {};

      var module = (cache[name] = new newRequire.Module(name));

      modules[name][0].call(
        module.exports,
        localRequire,
        module,
        module.exports,
        this
      );
    }

    return cache[name].exports;

    function localRequire(x) {
      var res = localRequire.resolve(x);
      return res === false ? {} : newRequire(res);
    }

    function resolve(x) {
      var id = modules[name][1][x];
      return id != null ? id : x;
    }
  }

  function Module(moduleName) {
    this.id = moduleName;
    this.bundle = newRequire;
    this.exports = {};
  }

  newRequire.isParcelRequire = true;
  newRequire.Module = Module;
  newRequire.modules = modules;
  newRequire.cache = cache;
  newRequire.parent = previousRequire;
  newRequire.register = function (id, exports) {
    modules[id] = [
      function (require, module) {
        module.exports = exports;
      },
      {},
    ];
  };

  Object.defineProperty(newRequire, 'root', {
    get: function () {
      return globalObject[parcelRequireName];
    },
  });

  globalObject[parcelRequireName] = newRequire;

  for (var i = 0; i < entry.length; i++) {
    newRequire(entry[i]);
  }

  if (mainEntry) {
    // Expose entry point to Node, AMD or browser globals
    // Based on https://github.com/ForbesLindesay/umd/blob/master/template.js
    var mainExports = newRequire(mainEntry);

    // CommonJS
    if (typeof exports === 'object' && typeof module !== 'undefined') {
      module.exports = mainExports;

      // RequireJS
    } else if (typeof define === 'function' && define.amd) {
      define(function () {
        return mainExports;
      });

      // <script>
    } else if (globalName) {
      this[globalName] = mainExports;
    }
  }
})({"856CK":[function(require,module,exports) {
var global = arguments[3];
var HMR_HOST = null;
var HMR_PORT = null;
var HMR_SECURE = false;
var HMR_ENV_HASH = "d6ea1d42532a7575";
var HMR_USE_SSE = false;
module.bundle.HMR_BUNDLE_ID = "92cd312b7e3e74fd";
"use strict";
/* global HMR_HOST, HMR_PORT, HMR_ENV_HASH, HMR_SECURE, HMR_USE_SSE, chrome, browser, __parcel__import__, __parcel__importScripts__, ServiceWorkerGlobalScope */ /*::
import type {
  HMRAsset,
  HMRMessage,
} from '@parcel/reporter-dev-server/src/HMRServer.js';
interface ParcelRequire {
  (string): mixed;
  cache: {|[string]: ParcelModule|};
  hotData: {|[string]: mixed|};
  Module: any;
  parent: ?ParcelRequire;
  isParcelRequire: true;
  modules: {|[string]: [Function, {|[string]: string|}]|};
  HMR_BUNDLE_ID: string;
  root: ParcelRequire;
}
interface ParcelModule {
  hot: {|
    data: mixed,
    accept(cb: (Function) => void): void,
    dispose(cb: (mixed) => void): void,
    // accept(deps: Array<string> | string, cb: (Function) => void): void,
    // decline(): void,
    _acceptCallbacks: Array<(Function) => void>,
    _disposeCallbacks: Array<(mixed) => void>,
  |};
}
interface ExtensionContext {
  runtime: {|
    reload(): void,
    getURL(url: string): string;
    getManifest(): {manifest_version: number, ...};
  |};
}
declare var module: {bundle: ParcelRequire, ...};
declare var HMR_HOST: string;
declare var HMR_PORT: string;
declare var HMR_ENV_HASH: string;
declare var HMR_SECURE: boolean;
declare var HMR_USE_SSE: boolean;
declare var chrome: ExtensionContext;
declare var browser: ExtensionContext;
declare var __parcel__import__: (string) => Promise<void>;
declare var __parcel__importScripts__: (string) => Promise<void>;
declare var globalThis: typeof self;
declare var ServiceWorkerGlobalScope: Object;
*/ var OVERLAY_ID = "__parcel__error__overlay__";
var OldModule = module.bundle.Module;
function Module(moduleName) {
    OldModule.call(this, moduleName);
    this.hot = {
        data: module.bundle.hotData[moduleName],
        _acceptCallbacks: [],
        _disposeCallbacks: [],
        accept: function(fn) {
            this._acceptCallbacks.push(fn || function() {});
        },
        dispose: function(fn) {
            this._disposeCallbacks.push(fn);
        }
    };
    module.bundle.hotData[moduleName] = undefined;
}
module.bundle.Module = Module;
module.bundle.hotData = {};
var checkedAssets /*: {|[string]: boolean|} */ , assetsToDispose /*: Array<[ParcelRequire, string]> */ , assetsToAccept /*: Array<[ParcelRequire, string]> */ ;
function getHostname() {
    return HMR_HOST || (location.protocol.indexOf("http") === 0 ? location.hostname : "localhost");
}
function getPort() {
    return HMR_PORT || location.port;
}
// eslint-disable-next-line no-redeclare
var parent = module.bundle.parent;
if ((!parent || !parent.isParcelRequire) && typeof WebSocket !== "undefined") {
    var hostname = getHostname();
    var port = getPort();
    var protocol = HMR_SECURE || location.protocol == "https:" && ![
        "localhost",
        "127.0.0.1",
        "0.0.0.0"
    ].includes(hostname) ? "wss" : "ws";
    var ws;
    if (HMR_USE_SSE) ws = new EventSource("/__parcel_hmr");
    else try {
        ws = new WebSocket(protocol + "://" + hostname + (port ? ":" + port : "") + "/");
    } catch (err) {
        if (err.message) console.error(err.message);
        ws = {};
    }
    // Web extension context
    var extCtx = typeof browser === "undefined" ? typeof chrome === "undefined" ? null : chrome : browser;
    // Safari doesn't support sourceURL in error stacks.
    // eval may also be disabled via CSP, so do a quick check.
    var supportsSourceURL = false;
    try {
        (0, eval)('throw new Error("test"); //# sourceURL=test.js');
    } catch (err) {
        supportsSourceURL = err.stack.includes("test.js");
    }
    // $FlowFixMe
    ws.onmessage = async function(event /*: {data: string, ...} */ ) {
        checkedAssets = {} /*: {|[string]: boolean|} */ ;
        assetsToAccept = [];
        assetsToDispose = [];
        var data /*: HMRMessage */  = JSON.parse(event.data);
        if (data.type === "update") {
            // Remove error overlay if there is one
            if (typeof document !== "undefined") removeErrorOverlay();
            let assets = data.assets.filter((asset)=>asset.envHash === HMR_ENV_HASH);
            // Handle HMR Update
            let handled = assets.every((asset)=>{
                return asset.type === "css" || asset.type === "js" && hmrAcceptCheck(module.bundle.root, asset.id, asset.depsByBundle);
            });
            if (handled) {
                console.clear();
                // Dispatch custom event so other runtimes (e.g React Refresh) are aware.
                if (typeof window !== "undefined" && typeof CustomEvent !== "undefined") window.dispatchEvent(new CustomEvent("parcelhmraccept"));
                await hmrApplyUpdates(assets);
                // Dispose all old assets.
                let processedAssets = {} /*: {|[string]: boolean|} */ ;
                for(let i = 0; i < assetsToDispose.length; i++){
                    let id = assetsToDispose[i][1];
                    if (!processedAssets[id]) {
                        hmrDispose(assetsToDispose[i][0], id);
                        processedAssets[id] = true;
                    }
                }
                // Run accept callbacks. This will also re-execute other disposed assets in topological order.
                processedAssets = {};
                for(let i = 0; i < assetsToAccept.length; i++){
                    let id = assetsToAccept[i][1];
                    if (!processedAssets[id]) {
                        hmrAccept(assetsToAccept[i][0], id);
                        processedAssets[id] = true;
                    }
                }
            } else fullReload();
        }
        if (data.type === "error") {
            // Log parcel errors to console
            for (let ansiDiagnostic of data.diagnostics.ansi){
                let stack = ansiDiagnostic.codeframe ? ansiDiagnostic.codeframe : ansiDiagnostic.stack;
                console.error("\uD83D\uDEA8 [parcel]: " + ansiDiagnostic.message + "\n" + stack + "\n\n" + ansiDiagnostic.hints.join("\n"));
            }
            if (typeof document !== "undefined") {
                // Render the fancy html overlay
                removeErrorOverlay();
                var overlay = createErrorOverlay(data.diagnostics.html);
                // $FlowFixMe
                document.body.appendChild(overlay);
            }
        }
    };
    if (ws instanceof WebSocket) {
        ws.onerror = function(e) {
            if (e.message) console.error(e.message);
        };
        ws.onclose = function() {
            console.warn("[parcel] \uD83D\uDEA8 Connection to the HMR server was lost");
        };
    }
}
function removeErrorOverlay() {
    var overlay = document.getElementById(OVERLAY_ID);
    if (overlay) {
        overlay.remove();
        console.log("[parcel] \u2728 Error resolved");
    }
}
function createErrorOverlay(diagnostics) {
    var overlay = document.createElement("div");
    overlay.id = OVERLAY_ID;
    let errorHTML = '<div style="background: black; opacity: 0.85; font-size: 16px; color: white; position: fixed; height: 100%; width: 100%; top: 0px; left: 0px; padding: 30px; font-family: Menlo, Consolas, monospace; z-index: 9999;">';
    for (let diagnostic of diagnostics){
        let stack = diagnostic.frames.length ? diagnostic.frames.reduce((p, frame)=>{
            return `${p}
<a href="/__parcel_launch_editor?file=${encodeURIComponent(frame.location)}" style="text-decoration: underline; color: #888" onclick="fetch(this.href); return false">${frame.location}</a>
${frame.code}`;
        }, "") : diagnostic.stack;
        errorHTML += `
      <div>
        <div style="font-size: 18px; font-weight: bold; margin-top: 20px;">
          \u{1F6A8} ${diagnostic.message}
        </div>
        <pre>${stack}</pre>
        <div>
          ${diagnostic.hints.map((hint)=>"<div>\uD83D\uDCA1 " + hint + "</div>").join("")}
        </div>
        ${diagnostic.documentation ? `<div>\u{1F4DD} <a style="color: violet" href="${diagnostic.documentation}" target="_blank">Learn more</a></div>` : ""}
      </div>
    `;
    }
    errorHTML += "</div>";
    overlay.innerHTML = errorHTML;
    return overlay;
}
function fullReload() {
    if ("reload" in location) location.reload();
    else if (extCtx && extCtx.runtime && extCtx.runtime.reload) extCtx.runtime.reload();
}
function getParents(bundle, id) /*: Array<[ParcelRequire, string]> */ {
    var modules = bundle.modules;
    if (!modules) return [];
    var parents = [];
    var k, d, dep;
    for(k in modules)for(d in modules[k][1]){
        dep = modules[k][1][d];
        if (dep === id || Array.isArray(dep) && dep[dep.length - 1] === id) parents.push([
            bundle,
            k
        ]);
    }
    if (bundle.parent) parents = parents.concat(getParents(bundle.parent, id));
    return parents;
}
function updateLink(link) {
    var href = link.getAttribute("href");
    if (!href) return;
    var newLink = link.cloneNode();
    newLink.onload = function() {
        if (link.parentNode !== null) // $FlowFixMe
        link.parentNode.removeChild(link);
    };
    newLink.setAttribute("href", // $FlowFixMe
    href.split("?")[0] + "?" + Date.now());
    // $FlowFixMe
    link.parentNode.insertBefore(newLink, link.nextSibling);
}
var cssTimeout = null;
function reloadCSS() {
    if (cssTimeout) return;
    cssTimeout = setTimeout(function() {
        var links = document.querySelectorAll('link[rel="stylesheet"]');
        for(var i = 0; i < links.length; i++){
            // $FlowFixMe[incompatible-type]
            var href /*: string */  = links[i].getAttribute("href");
            var hostname = getHostname();
            var servedFromHMRServer = hostname === "localhost" ? new RegExp("^(https?:\\/\\/(0.0.0.0|127.0.0.1)|localhost):" + getPort()).test(href) : href.indexOf(hostname + ":" + getPort());
            var absolute = /^https?:\/\//i.test(href) && href.indexOf(location.origin) !== 0 && !servedFromHMRServer;
            if (!absolute) updateLink(links[i]);
        }
        cssTimeout = null;
    }, 50);
}
function hmrDownload(asset) {
    if (asset.type === "js") {
        if (typeof document !== "undefined") {
            let script = document.createElement("script");
            script.src = asset.url + "?t=" + Date.now();
            if (asset.outputFormat === "esmodule") script.type = "module";
            return new Promise((resolve, reject)=>{
                var _document$head;
                script.onload = ()=>resolve(script);
                script.onerror = reject;
                (_document$head = document.head) === null || _document$head === void 0 || _document$head.appendChild(script);
            });
        } else if (typeof importScripts === "function") {
            // Worker scripts
            if (asset.outputFormat === "esmodule") return import(asset.url + "?t=" + Date.now());
            else return new Promise((resolve, reject)=>{
                try {
                    importScripts(asset.url + "?t=" + Date.now());
                    resolve();
                } catch (err) {
                    reject(err);
                }
            });
        }
    }
}
async function hmrApplyUpdates(assets) {
    global.parcelHotUpdate = Object.create(null);
    let scriptsToRemove;
    try {
        // If sourceURL comments aren't supported in eval, we need to load
        // the update from the dev server over HTTP so that stack traces
        // are correct in errors/logs. This is much slower than eval, so
        // we only do it if needed (currently just Safari).
        // https://bugs.webkit.org/show_bug.cgi?id=137297
        // This path is also taken if a CSP disallows eval.
        if (!supportsSourceURL) {
            let promises = assets.map((asset)=>{
                var _hmrDownload;
                return (_hmrDownload = hmrDownload(asset)) === null || _hmrDownload === void 0 ? void 0 : _hmrDownload.catch((err)=>{
                    // Web extension fix
                    if (extCtx && extCtx.runtime && extCtx.runtime.getManifest().manifest_version == 3 && typeof ServiceWorkerGlobalScope != "undefined" && global instanceof ServiceWorkerGlobalScope) {
                        extCtx.runtime.reload();
                        return;
                    }
                    throw err;
                });
            });
            scriptsToRemove = await Promise.all(promises);
        }
        assets.forEach(function(asset) {
            hmrApply(module.bundle.root, asset);
        });
    } finally{
        delete global.parcelHotUpdate;
        if (scriptsToRemove) scriptsToRemove.forEach((script)=>{
            if (script) {
                var _document$head2;
                (_document$head2 = document.head) === null || _document$head2 === void 0 || _document$head2.removeChild(script);
            }
        });
    }
}
function hmrApply(bundle /*: ParcelRequire */ , asset /*:  HMRAsset */ ) {
    var modules = bundle.modules;
    if (!modules) return;
    if (asset.type === "css") reloadCSS();
    else if (asset.type === "js") {
        let deps = asset.depsByBundle[bundle.HMR_BUNDLE_ID];
        if (deps) {
            if (modules[asset.id]) {
                // Remove dependencies that are removed and will become orphaned.
                // This is necessary so that if the asset is added back again, the cache is gone, and we prevent a full page reload.
                let oldDeps = modules[asset.id][1];
                for(let dep in oldDeps)if (!deps[dep] || deps[dep] !== oldDeps[dep]) {
                    let id = oldDeps[dep];
                    let parents = getParents(module.bundle.root, id);
                    if (parents.length === 1) hmrDelete(module.bundle.root, id);
                }
            }
            if (supportsSourceURL) // Global eval. We would use `new Function` here but browser
            // support for source maps is better with eval.
            (0, eval)(asset.output);
            // $FlowFixMe
            let fn = global.parcelHotUpdate[asset.id];
            modules[asset.id] = [
                fn,
                deps
            ];
        } else if (bundle.parent) hmrApply(bundle.parent, asset);
    }
}
function hmrDelete(bundle, id) {
    let modules = bundle.modules;
    if (!modules) return;
    if (modules[id]) {
        // Collect dependencies that will become orphaned when this module is deleted.
        let deps = modules[id][1];
        let orphans = [];
        for(let dep in deps){
            let parents = getParents(module.bundle.root, deps[dep]);
            if (parents.length === 1) orphans.push(deps[dep]);
        }
        // Delete the module. This must be done before deleting dependencies in case of circular dependencies.
        delete modules[id];
        delete bundle.cache[id];
        // Now delete the orphans.
        orphans.forEach((id)=>{
            hmrDelete(module.bundle.root, id);
        });
    } else if (bundle.parent) hmrDelete(bundle.parent, id);
}
function hmrAcceptCheck(bundle /*: ParcelRequire */ , id /*: string */ , depsByBundle /*: ?{ [string]: { [string]: string } }*/ ) {
    if (hmrAcceptCheckOne(bundle, id, depsByBundle)) return true;
    // Traverse parents breadth first. All possible ancestries must accept the HMR update, or we'll reload.
    let parents = getParents(module.bundle.root, id);
    let accepted = false;
    while(parents.length > 0){
        let v = parents.shift();
        let a = hmrAcceptCheckOne(v[0], v[1], null);
        if (a) // If this parent accepts, stop traversing upward, but still consider siblings.
        accepted = true;
        else {
            // Otherwise, queue the parents in the next level upward.
            let p = getParents(module.bundle.root, v[1]);
            if (p.length === 0) {
                // If there are no parents, then we've reached an entry without accepting. Reload.
                accepted = false;
                break;
            }
            parents.push(...p);
        }
    }
    return accepted;
}
function hmrAcceptCheckOne(bundle /*: ParcelRequire */ , id /*: string */ , depsByBundle /*: ?{ [string]: { [string]: string } }*/ ) {
    var modules = bundle.modules;
    if (!modules) return;
    if (depsByBundle && !depsByBundle[bundle.HMR_BUNDLE_ID]) {
        // If we reached the root bundle without finding where the asset should go,
        // there's nothing to do. Mark as "accepted" so we don't reload the page.
        if (!bundle.parent) return true;
        return hmrAcceptCheck(bundle.parent, id, depsByBundle);
    }
    if (checkedAssets[id]) return true;
    checkedAssets[id] = true;
    var cached = bundle.cache[id];
    assetsToDispose.push([
        bundle,
        id
    ]);
    if (!cached || cached.hot && cached.hot._acceptCallbacks.length) {
        assetsToAccept.push([
            bundle,
            id
        ]);
        return true;
    }
}
function hmrDispose(bundle /*: ParcelRequire */ , id /*: string */ ) {
    var cached = bundle.cache[id];
    bundle.hotData[id] = {};
    if (cached && cached.hot) cached.hot.data = bundle.hotData[id];
    if (cached && cached.hot && cached.hot._disposeCallbacks.length) cached.hot._disposeCallbacks.forEach(function(cb) {
        cb(bundle.hotData[id]);
    });
    delete bundle.cache[id];
}
function hmrAccept(bundle /*: ParcelRequire */ , id /*: string */ ) {
    // Execute the module.
    bundle(id);
    // Run the accept callbacks in the new version of the module.
    var cached = bundle.cache[id];
    if (cached && cached.hot && cached.hot._acceptCallbacks.length) cached.hot._acceptCallbacks.forEach(function(cb) {
        var assetsToAlsoAccept = cb(function() {
            return getParents(module.bundle.root, id);
        });
        if (assetsToAlsoAccept && assetsToAccept.length) {
            assetsToAlsoAccept.forEach(function(a) {
                hmrDispose(a[0], a[1]);
            });
            // $FlowFixMe[method-unbinding]
            assetsToAccept.push.apply(assetsToAccept, assetsToAlsoAccept);
        }
    });
}

},{}],"b9zwu":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
var _colyseusJs = require("colyseus.js");
var _cjs = require("hashids/cjs");
var _cjsDefault = parcelHelpers.interopDefault(_cjs);
var _png = require("../img/*.png");
var _loginClient = require("../utils/LoginClient");
var __awaiter = undefined && undefined.__awaiter || function(thisArg, _arguments, P, generator) {
    function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
            resolve(value);
        });
    }
    return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
            try {
                step(generator.next(value));
            } catch (e) {
                reject(e);
            }
        }
        function rejected(value) {
            try {
                step(generator["throw"](value));
            } catch (e) {
                reject(e);
            }
        }
        function step(result) {
            result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class AvalonGameClient {
    constructor(serverUrl){
        this.proposed_party = new Set();
        this.client = new (0, _colyseusJs.Client)(serverUrl);
        this.userId = this.generateUserId();
    }
    generateUserId() {
        // Generate or retrieve a unique user ID
        this.hashids = new (0, _cjsDefault.default)("your-salt", 10);
        this.userId = localStorage.getItem("userId");
        if (!this.userId) {
            this.userId = this.generateUniqueId(); // Implement a function to generate a unique ID
            localStorage.setItem("userId", this.userId);
        }
        return this.userId;
    }
    generateUniqueId() {
        const now = Date.now(); // Get current time in milliseconds
        const seconds = Math.floor(now / 1000); // Extract seconds
        const milliseconds = now % 1000; // Extract milliseconds
        // Encode both seconds and milliseconds
        const uniqueId = this.hashids.encode(seconds, milliseconds);
        return uniqueId;
    }
    handlePrivateData(callback) {
        this.room.onMessage("private_data", (message)=>{
            console.log(message);
            const { player } = message.data;
            const player_position = player.id;
            const player_role_field = document.getElementById(`player-predicted-role-${player_position}`);
            if (player_role_field) player_role_field.innerHTML = player.role.split("-")[0];
            // Set player icon:
            const player_icon = document.getElementById(`player-portrait-${player_position}`);
            if (player_icon) {
                player_icon.src = _png[`${player.role.toLowerCase()}`];
                player_icon.style.display = "block";
            }
            // Remove belief selector
            const belief_selector = document.getElementById(`player-belief-${player_position}`);
            if (belief_selector) // Disable the dropdown
            belief_selector.disabled = true;
            // Setup the private data if needed...
            for (const [key, value] of Object.entries(player.knowledge)){
                const element = document.getElementById(`${value}-ring-${key}`);
                if (element) element.style.display = "block";
            }
            // set up assassin stuff
            if (player.role.toLowerCase() === "assassin") {
                for(let i = 1; i <= this.room.state.players.length; i++)// Check if the player with index i is in my_knowledge
                if (!player.knowledge[i] && player.id != i) {
                    const element = document.getElementById(`player-predicted-role-${i}`);
                    if (element) element.innerHTML = '<span style="color: red;"><i>Assassinate</i></span>';
                    const element_2 = document.getElementById(`player-role-box-${i}`);
                    if (element_2) {
                        element_2.classList.add("brighten-on-hover");
                        element_2.addEventListener("click", (event)=>{
                            // Cast the event target to an HTMLDivElement
                            if (event && event.target) {
                                console.log("there was a click!");
                                const divId = event.target;
                                gameClient.processAssassination(divId.id);
                            }
                        });
                    }
                }
            }
            this.my_name = player.name;
            this.my_pid = player.id;
            this.my_role = player.role;
            this.my_knowledge = player.knowledge;
            callback();
        });
    }
    handleSpectatorData() {
        this.room.onMessage("spectator_data", (response)=>{
            const { data } = response;
            for (const player of data){
                const player_position = player.id;
                const player_role_field = document.getElementById(`player-predicted-role-${player_position}`);
                if (player_role_field) player_role_field.innerHTML = player.role.split("-")[0];
                // Set player icon:
                const player_icon = document.getElementById(`player-portrait-${player_position}`);
                if (player_icon) {
                    player_icon.src = _png[`${player.role.toLowerCase()}`];
                    player_icon.style.display = "block";
                }
                // Remove belief selector
                const belief_selector = document.getElementById(`player-belief-${player_position}`);
                if (belief_selector) // Disable the dropdown
                belief_selector.disabled = true;
                // Setup the private data if needed...
                for (const [key, value] of Object.entries(player.knowledge)){
                    const element = document.getElementById(`${value}-ring-${key}`);
                    if (element) element.style.display = "block";
                }
            }
        });
    }
    joinRoom(roomID, admin) {
        return __awaiter(this, void 0, void 0, function*() {
            try {
                this.room = yield this.client.joinById(roomID, {
                    userId: localStorage.getItem("userId"),
                    accessToken: localStorage.getItem("accessToken"),
                    spectator: admin
                });
                // Store reconnection token and room ID before the window unloads
                window.onbeforeunload = ()=>{
                    localStorage.setItem("reconnectionToken", this.room.reconnectionToken);
                    localStorage.setItem("roomId", this.room.id);
                };
            } catch (e) {
                console.error("Error joining room", e);
                this.showErrorMessage(e.message);
            // logout();
            }
            this.handleSpectatorData();
            // Initial update
            this.updatePlayerCount(this.room.state.players.length);
            const handleTurnChange = (turn_pid)=>{
                const prev = turn_pid > 1 ? turn_pid - 1 : 6;
                const prev_arrow = document.getElementById(`jester-${prev}`);
                if (prev_arrow) prev_arrow.style.display = "none";
                const new_arrow = document.getElementById(`jester-${turn_pid}`);
                if (new_arrow) new_arrow.style.display = "block";
            };
            const handleLeaderChange = (leader_pid)=>{
                const prev = leader_pid > 1 ? leader_pid - 1 : 6;
                const prev_crown = document.getElementById(`crown-${prev}`);
                if (prev_crown) prev_crown.style.display = "none";
                const new_crown = document.getElementById(`crown-${leader_pid}`);
                if (new_crown) new_crown.style.display = "block";
            };
            const handleFailedPartyVotes = (failedPartVotes)=>{
                // loop through the failed votes and set them to display: block
                for(let i = 1; i <= 5; i++){
                    const failed_vote = document.getElementById(`party-image-${i}`);
                    if (!failed_vote) continue;
                    if (i <= failedPartVotes) failed_vote.style.display = "block";
                    else failed_vote.style.display = "none";
                }
            };
            // ********************** START LISTENERS ********************** //
            const handleStatechange = (state)=>{
                handleTurnChange(state.turn_pid);
                handleLeaderChange(state.leader_pid);
                handleFailedPartyVotes(state.failed_party_votes);
            };
            this.room.state.proposed_party.onAdd((player, key)=>{
                // If it's not our turn, just show the current party
                if (this.room.state.turn_pid != this.my_pid) for(let i = 1; i <= 6; i++)this.toggleShield(i, this.room.state.proposed_party.includes(i));
            });
            this.room.state.players.onAdd((player, key)=>{
                this.updatePlayerCount(this.room.state.players.length);
            });
            this.room.state.players.onRemove((player, key)=>{
                this.updatePlayerCount(this.room.state.players.length);
            });
            // For all previous messages, add them to the chat
            this.room.state.messages.onAdd((message, key)=>{
                this.addMessage(message);
            });
            // Listen for quest results
            this.room.state.quest_results.onAdd((result, key)=>{
                // Loop over all of them and set the right images:
                for(let i = 1; i <= this.room.state.quest_results.length; i++){
                    const quest_result = document.getElementById(`quest-image-${i}`);
                    if (!quest_result) continue;
                    quest_result.style.display = "block";
                    quest_result.src = this.room.state.quest_results[i - 1] === "success" ? _png["quest-success"] : _png["quest-fail"];
                }
            });
            // Listen for changes in all_joined
            this.room.state.listen("all_joined", (currentValue, previousValue)=>{
                // return if the value is false
                if (currentValue === false) return;
                const waitingAElement = document.getElementById("waiting_a");
                const waitingBElement = document.getElementById("waiting_b");
                const hiderAElement = document.getElementById("hider_a");
                const hiderBElement = document.getElementById("hider_b");
                if (waitingAElement) waitingAElement.style.display = "none";
                if (waitingBElement) waitingBElement.style.display = "none";
                if (hiderAElement) hiderAElement.style.display = "block";
                if (hiderBElement) hiderBElement.style.display = "block";
                // Iterate through the players array
                this.room.state.players.forEach((player, index)=>{
                    // set player by loop index
                    const playerElement = document.getElementById(`player-name-${index + 1}`);
                    if (playerElement) playerElement.innerHTML = player;
                });
            });
            this.room.onStateChange((state)=>{
                handleStatechange(state);
            });
        // ********************** END LISTENERS ********************** //
        });
    }
    reconnect(reconnectionToken) {
        return __awaiter(this, void 0, void 0, function*() {
            console.log("reconnecitng with token", reconnectionToken);
            try {
                this.room = yield this.client.reconnect(reconnectionToken);
                console.log("Reconnected!");
            } catch (error) {
                console.error("Reconnection failed:", error);
            // Retry logic could be implemented here
            }
        });
    }
    /**used to toggle shield based on other player's party proposals */ toggleShield(player_position, force) {
        const shield = document.getElementById(`shield-${player_position}`);
        if (shield) {
            if (force !== undefined) shield.style.display = force ? "block" : "none";
            else {
                const canProposeParty = this.room.state.leader_pid === this.room.state.turn_pid && this.my_pid === this.room.state.leader_pid && !this.room.state.vote_party && !this.room.state.vote_quest;
                if (canProposeParty) shield.style.display = shield.style.display === "block" ? "none" : "block";
            }
        }
    }
    addMessage(message) {
        const iDiv = document.createElement("div");
        iDiv.className = "message-container";
        if (message.player === this.my_name) iDiv.style.backgroundColor = "rgba(0, 255, 191, 0.3)";
        else if (message.player === "system") iDiv.style.backgroundColor = "rgba(255, 0, 191, 0.3)";
        else iDiv.style.backgroundColor = "rgba(255, 191, 0, 0.3)";
        iDiv.innerHTML = `<div class='message-strategy'></div><div class='message-inner'>${message.player}: ${message.msg}</div>`;
        const chat = document.getElementById("chat");
        if (chat) chat.appendChild(iDiv);
        this.updateScroll();
    }
    updatePlayerCount(playerCount) {
        const waitingElement = document.getElementById("waiting_a");
        if (waitingElement) waitingElement.innerHTML = `<h3 style="text-align: center;">Waiting for players... (${playerCount}/6)</h3>`;
    }
    showErrorMessage(message) {
        const waitingElement = document.getElementById("waiting_a");
        if (waitingElement) waitingElement.innerHTML = `<h3 style="text-align: center; color: red;">Error: ${message}</h3>`;
    }
    updateScroll() {
        const chat = document.getElementById("chat");
        if (chat) chat.scrollTop = chat.scrollHeight;
    }
    arraysContainSameItems(arr1, arr2) {
        if (arr1.length !== arr2.length) return false;
        // Compare the sorted arrays
        for(let i = 0; i < arr1.length; i++){
            // Check if arr2 contains the element
            if (arr2.indexOf(arr1[i]) === -1) return false;
        }
        return true;
    }
}
// Define the function in the global scope
function toggleHelpBox() {
    var _a, _b;
    const helpBox = document.getElementById("help_box");
    if (helpBox) {
        if ((helpBox === null || helpBox === void 0 ? void 0 : helpBox.style.display) === "none" || ((_a = helpBox.style) === null || _a === void 0 ? void 0 : _a.display) === "" || !((_b = helpBox.style) === null || _b === void 0 ? void 0 : _b.display)) helpBox.style.display = "block";
        else helpBox.style.display = "none";
    } else console.log("Help box not found");
}
const gameClient = new AvalonGameClient((0, _loginClient.SERVER_URL));
document.addEventListener("DOMContentLoaded", ()=>{
    const helpButton = document.getElementById("help_button");
    if (helpButton) helpButton.addEventListener("click", (event)=>{
        toggleHelpBox();
    });
    else console.log("Help button not found");
    document.addEventListener("click", (event)=>{
        const helpBox = document.getElementById("help_box");
        const helpButton = document.getElementById("help_button");
        if (helpBox && helpButton) {
            if (!helpBox.contains(event.target) && !helpButton.contains(event.target)) helpBox.style.display = "none";
        }
    });
    const questBar = document.getElementById("quest-bar");
    const qsize = [
        2,
        3,
        4,
        3,
        4
    ];
    for(let i = 1; i <= 5; i++){
        const questRing = document.createElement("div");
        questRing.className = "quest-ring";
        questRing.style.left = `${(i - 1) * 62}px`;
        const questText = document.createElement("div");
        questText.className = "quest-text";
        questText.innerText = qsize[i - 1] || "";
        const questImage = document.createElement("img");
        questImage.className = "quest-image";
        questImage.id = `quest-image-${i}`;
        questImage.style.display = "none";
        questImage.src = "quest-success.png"; // Adjust the path as needed
        questRing.appendChild(questText);
        questRing.appendChild(questImage);
        questBar === null || questBar === void 0 || questBar.appendChild(questRing);
    }
    // Add the party bar
    const partyBar = document.getElementById("party-bar");
    for(let i = 1; i <= 5; i++){
        const partyRing = document.createElement("div");
        partyRing.className = "party-ring";
        partyRing.style.left = `${(i - 1) * 40}px`;
        if (i === 5) partyRing.style.backgroundColor = "maroon";
        const partyImage = document.createElement("img");
        partyImage.className = "party-image";
        partyImage.id = `party-image-${i}`;
        partyImage.style.display = "none";
        partyImage.src = _png["chip"]; // Adjust the path as needed
        partyRing.appendChild(partyImage);
        partyBar === null || partyBar === void 0 || partyBar.appendChild(partyRing);
    }
    // Add the player box
    const playerBox = document.getElementById("player-box");
    for(let i = 1; i <= 6; i++){
        const playerLoc = document.createElement("div");
        playerLoc.className = `player-box player-loc-${i}`;
        const playerFrame = document.createElement("img");
        playerFrame.className = "player-frame";
        playerFrame.id = `player-frame-${i}`;
        playerFrame.src = _png["avatar-frame"];
        playerLoc.appendChild(playerFrame);
        const playerNameBox = document.createElement("img");
        playerNameBox.className = "player-name-box";
        playerNameBox.src = _png["name-frame"];
        playerLoc.appendChild(playerNameBox);
        const playerPortrait = document.createElement("img");
        playerPortrait.className = "player-portrait";
        playerPortrait.id = `player-portrait-${i}`;
        playerPortrait.style.display = "none";
        playerPortrait.src = "empty.png";
        playerLoc.appendChild(playerPortrait);
        const playerRoleBox = document.createElement("img");
        playerRoleBox.className = "player-role-box";
        playerRoleBox.id = `player-role-box-${i}`;
        playerRoleBox.src = _png["name-frame"];
        playerLoc.appendChild(playerRoleBox);
        const xMark = document.createElement("div");
        xMark.className = "x-mark";
        xMark.id = `x-mark-${i}`;
        xMark.style.display = "none";
        playerLoc.appendChild(xMark);
        const evilRing = document.createElement("div");
        evilRing.className = "evil-ring";
        evilRing.id = `evil-ring-${i}`;
        evilRing.style.display = "none";
        playerLoc.appendChild(evilRing);
        const goodRing = document.createElement("div");
        goodRing.className = "good-ring";
        goodRing.id = `good-ring-${i}`;
        goodRing.style.display = "none";
        playerLoc.appendChild(goodRing);
        const unknownRing = document.createElement("div");
        unknownRing.className = "unknown-ring";
        unknownRing.id = `unknown-ring-${i}`;
        unknownRing.style.display = "none";
        playerLoc.appendChild(unknownRing);
        const disconnected = document.createElement("div");
        disconnected.className = "disconnected";
        disconnected.id = `disconnected-${i}`;
        disconnected.style.display = "none";
        playerLoc.appendChild(disconnected);
        const crown = document.createElement("div");
        crown.className = "crown";
        crown.id = `crown-${i}`;
        crown.style.display = "none";
        playerLoc.appendChild(crown);
        const jester = document.createElement("div");
        jester.className = "jester";
        jester.id = `jester-${i}`;
        jester.style.display = "none";
        playerLoc.appendChild(jester);
        const shield = document.createElement("div");
        shield.className = "shield";
        shield.id = `shield-${i}`;
        shield.style.display = "none";
        playerLoc.appendChild(shield);
        const playerName = document.createElement("div");
        playerName.className = "player-name";
        playerName.id = `player-name-${i}`;
        playerName.innerText = "...";
        playerLoc.appendChild(playerName);
        const playerPredictedRole = document.createElement("div");
        playerPredictedRole.className = "player-predicted-role";
        playerPredictedRole.id = `player-predicted-role-${i}`;
        playerPredictedRole.innerText = "";
        playerLoc.appendChild(playerPredictedRole);
        const playerBelief = document.createElement("select");
        playerBelief.className = "player-belief";
        playerBelief.name = `player-${i}-belief`;
        playerBelief.id = `player-belief-${i}`;
        playerBelief.onchange = ()=>selectBelief(playerBelief.id);
        const optionUndecided = document.createElement("option");
        optionUndecided.value = "undecided";
        optionUndecided.innerText = "Undecided";
        playerBelief.appendChild(optionUndecided);
        const optGroupArthur = document.createElement("optgroup");
        optGroupArthur.label = "Arthur's Servants";
        optGroupArthur.className = "green";
        const optionMerlin = document.createElement("option");
        optionMerlin.value = "merlin";
        optionMerlin.innerText = "Merlin";
        optGroupArthur.appendChild(optionMerlin);
        const optionPercival = document.createElement("option");
        optionPercival.value = "percival";
        optionPercival.innerText = "Percival";
        optGroupArthur.appendChild(optionPercival);
        const optionServant = document.createElement("option");
        optionServant.value = "servant";
        optionServant.innerText = "Servant";
        optGroupArthur.appendChild(optionServant);
        playerBelief.appendChild(optGroupArthur);
        const optGroupMordred = document.createElement("optgroup");
        optGroupMordred.label = "Mordred's Servants";
        const optionAssassin = document.createElement("option");
        optionAssassin.value = "assassin";
        optionAssassin.innerText = "Assassin";
        optGroupMordred.appendChild(optionAssassin);
        const optionMorgana = document.createElement("option");
        optionMorgana.value = "morgana";
        optionMorgana.innerText = "Morgana";
        optGroupMordred.appendChild(optionMorgana);
        const optionMinion = document.createElement("option");
        optionMinion.value = "minion";
        optionMinion.innerText = "Minion";
        optGroupMordred.appendChild(optionMinion);
        playerBelief.appendChild(optGroupMordred);
        playerLoc.appendChild(playerBelief);
        playerBox === null || playerBox === void 0 || playerBox.appendChild(playerLoc);
    }
});
function main() {
    return __awaiter(this, void 0, void 0, function*() {
        const queryString = window.location.search;
        const urlParams = new URLSearchParams(queryString);
        const cmode = urlParams.get("cmode");
        if (cmode === "j") {
            const roomID = urlParams.get("roomID");
            if (roomID) gameClient.joinRoom(roomID, true);
        } else console.log("No mode specified");
    });
}
main();

},{"colyseus.js":"1QKAp","hashids/cjs":"cblNb","../img/*.png":"3SMsy","../utils/LoginClient":"ahYcD","@parcel/transformer-js/src/esmodule-helpers.js":"gkKU3"}],"cblNb":[function(require,module,exports) {
module.exports = require("27d277b82b19016d").default;

},{"27d277b82b19016d":"7DnUD"}],"7DnUD":[function(require,module,exports) {
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
const util_1 = require("181052e33a1b09c2");
const MIN_ALPHABET_LENGTH = 16;
const SEPARATOR_DIV = 3.5;
const GUARD_DIV = 12;
const HEXADECIMAL = 16;
const SPLIT_AT_EVERY_NTH = 12;
const MODULO_PART = 100;
class Hashids {
    constructor(salt = "", minLength = 0, alphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890", seps = "cfhistuCFHISTU"){
        this.minLength = minLength;
        if (typeof minLength !== "number") throw new TypeError(`Hashids: Provided 'minLength' has to be a number (is ${typeof minLength})`);
        if (typeof salt !== "string") throw new TypeError(`Hashids: Provided 'salt' has to be a string (is ${typeof salt})`);
        if (typeof alphabet !== "string") throw new TypeError(`Hashids: Provided alphabet has to be a string (is ${typeof alphabet})`);
        const saltChars = Array.from(salt);
        const alphabetChars = Array.from(alphabet);
        const sepsChars = Array.from(seps);
        this.salt = saltChars;
        const uniqueAlphabet = (0, util_1.keepUnique)(alphabetChars);
        if (uniqueAlphabet.length < MIN_ALPHABET_LENGTH) throw new Error(`Hashids: alphabet must contain at least ${MIN_ALPHABET_LENGTH} unique characters, provided: ${uniqueAlphabet.join("")}`);
        /** `alphabet` should not contains `seps` */ this.alphabet = (0, util_1.withoutChars)(uniqueAlphabet, sepsChars);
        /** `seps` should contain only characters present in `alphabet` */ const filteredSeps = (0, util_1.onlyChars)(sepsChars, uniqueAlphabet);
        this.seps = (0, util_1.shuffle)(filteredSeps, saltChars);
        let sepsLength;
        let diff;
        if (this.seps.length === 0 || this.alphabet.length / this.seps.length > SEPARATOR_DIV) {
            sepsLength = Math.ceil(this.alphabet.length / SEPARATOR_DIV);
            if (sepsLength > this.seps.length) {
                diff = sepsLength - this.seps.length;
                this.seps.push(...this.alphabet.slice(0, diff));
                this.alphabet = this.alphabet.slice(diff);
            }
        }
        this.alphabet = (0, util_1.shuffle)(this.alphabet, saltChars);
        const guardCount = Math.ceil(this.alphabet.length / GUARD_DIV);
        if (this.alphabet.length < 3) {
            this.guards = this.seps.slice(0, guardCount);
            this.seps = this.seps.slice(guardCount);
        } else {
            this.guards = this.alphabet.slice(0, guardCount);
            this.alphabet = this.alphabet.slice(guardCount);
        }
        this.guardsRegExp = (0, util_1.makeAnyOfCharsRegExp)(this.guards);
        this.sepsRegExp = (0, util_1.makeAnyOfCharsRegExp)(this.seps);
        this.allowedCharsRegExp = (0, util_1.makeAtLeastSomeCharRegExp)([
            ...this.alphabet,
            ...this.guards,
            ...this.seps
        ]);
    }
    encode(first, ...inputNumbers) {
        const ret = "";
        let numbers = Array.isArray(first) ? first : [
            ...first != null ? [
                first
            ] : [],
            ...inputNumbers
        ];
        if (numbers.length === 0) return ret;
        if (!numbers.every(util_1.isIntegerNumber)) numbers = numbers.map((n)=>typeof n === "bigint" || typeof n === "number" ? n : (0, util_1.safeParseInt10)(String(n)));
        if (!numbers.every(util_1.isPositiveAndFinite)) return ret;
        return this._encode(numbers).join("");
    }
    decode(id) {
        if (!id || typeof id !== "string" || id.length === 0) return [];
        return this._decode(id);
    }
    /**
     * @description Splits a hex string into groups of 12-digit hexadecimal numbers,
     * then prefixes each with '1' and encodes the resulting array of numbers
     *
     * Encoding '00000000000f00000000000f000f' would be the equivalent of:
     * Hashids.encode([0x100000000000f, 0x100000000000f, 0x1000f])
     *
     * This means that if your environment supports BigInts,
     * you will get different (shorter) results if you provide
     * a BigInt representation of your hex and use `encode` directly, e.g.:
     * Hashids.encode(BigInt(`0x${hex}`))
     *
     * To decode such a representation back to a hex string, use the following snippet:
     * Hashids.decode(id)[0].toString(16)
     */ encodeHex(inputHex) {
        let hex = inputHex;
        switch(typeof hex){
            case "bigint":
                hex = hex.toString(HEXADECIMAL);
                break;
            case "string":
                if (!/^[\dA-Fa-f]+$/.test(hex)) return "";
                break;
            default:
                throw new Error(`Hashids: The provided value is neither a string, nor a BigInt (got: ${typeof hex})`);
        }
        const numbers = (0, util_1.splitAtIntervalAndMap)(hex, SPLIT_AT_EVERY_NTH, (part)=>Number.parseInt(`1${part}`, 16));
        return this.encode(numbers);
    }
    decodeHex(id) {
        return this.decode(id).map((number)=>number.toString(HEXADECIMAL).slice(1)).join("");
    }
    isValidId(id) {
        return this.allowedCharsRegExp.test(id);
    }
    _encode(numbers) {
        let { alphabet } = this;
        const numbersIdInt = numbers.reduce((last, number, i)=>last + (typeof number === "bigint" ? Number(number % BigInt(i + MODULO_PART)) : number % (i + MODULO_PART)), 0);
        let ret = [
            alphabet[numbersIdInt % alphabet.length]
        ];
        const lottery = [
            ...ret
        ];
        const { seps } = this;
        const { guards } = this;
        numbers.forEach((number, i)=>{
            const buffer = lottery.concat(this.salt, alphabet);
            alphabet = (0, util_1.shuffle)(alphabet, buffer);
            const last = (0, util_1.toAlphabet)(number, alphabet);
            ret.push(...last);
            if (i + 1 < numbers.length) {
                const charCode = last[0].codePointAt(0) + i;
                const extraNumber = typeof number === "bigint" ? Number(number % BigInt(charCode)) : number % charCode;
                ret.push(seps[extraNumber % seps.length]);
            }
        });
        if (ret.length < this.minLength) {
            const prefixGuardIndex = (numbersIdInt + ret[0].codePointAt(0)) % guards.length;
            ret.unshift(guards[prefixGuardIndex]);
            if (ret.length < this.minLength) {
                const suffixGuardIndex = (numbersIdInt + ret[2].codePointAt(0)) % guards.length;
                ret.push(guards[suffixGuardIndex]);
            }
        }
        const halfLength = Math.floor(alphabet.length / 2);
        while(ret.length < this.minLength){
            alphabet = (0, util_1.shuffle)(alphabet, alphabet);
            ret.unshift(...alphabet.slice(halfLength));
            ret.push(...alphabet.slice(0, halfLength));
            const excess = ret.length - this.minLength;
            if (excess > 0) {
                const halfOfExcess = excess / 2;
                ret = ret.slice(halfOfExcess, halfOfExcess + this.minLength);
            }
        }
        return ret;
    }
    _decode(id) {
        if (!this.isValidId(id)) throw new Error(`The provided ID (${id}) is invalid, as it contains characters that do not exist in the alphabet (${this.guards.join("")}${this.seps.join("")}${this.alphabet.join("")})`);
        const idGuardsArray = id.split(this.guardsRegExp);
        const splitIndex = idGuardsArray.length === 3 || idGuardsArray.length === 2 ? 1 : 0;
        const idBreakdown = idGuardsArray[splitIndex];
        if (idBreakdown.length === 0) return [];
        const lotteryChar = idBreakdown[Symbol.iterator]().next().value;
        const idArray = idBreakdown.slice(lotteryChar.length).split(this.sepsRegExp);
        let lastAlphabet = this.alphabet;
        const result = [];
        for (const subId of idArray){
            const buffer = [
                lotteryChar,
                ...this.salt,
                ...lastAlphabet
            ];
            const nextAlphabet = (0, util_1.shuffle)(lastAlphabet, buffer.slice(0, lastAlphabet.length));
            result.push((0, util_1.fromAlphabet)(Array.from(subId), nextAlphabet));
            lastAlphabet = nextAlphabet;
        }
        // if the result is different from what we'd expect, we return an empty result (malformed input):
        if (this._encode(result).join("") !== id) return [];
        return result;
    }
}
exports.default = Hashids;

},{"181052e33a1b09c2":"w622V"}],"w622V":[function(require,module,exports) {
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.makeAtLeastSomeCharRegExp = exports.makeAnyOfCharsRegExp = exports.splitAtIntervalAndMap = exports.safeParseInt10 = exports.fromAlphabet = exports.toAlphabet = exports.shuffle = exports.isPositiveAndFinite = exports.isIntegerNumber = exports.onlyChars = exports.withoutChars = exports.keepUnique = void 0;
const keepUnique = (content)=>[
        ...new Set(content)
    ];
exports.keepUnique = keepUnique;
const withoutChars = (chars, charsToExclude)=>chars.filter((char)=>!charsToExclude.includes(char));
exports.withoutChars = withoutChars;
const onlyChars = (chars, keepChars)=>chars.filter((char)=>keepChars.includes(char));
exports.onlyChars = onlyChars;
const isIntegerNumber = (n)=>typeof n === "bigint" || !Number.isNaN(Number(n)) && Math.floor(Number(n)) === n;
exports.isIntegerNumber = isIntegerNumber;
const isPositiveAndFinite = (n)=>typeof n === "bigint" || n >= 0 && Number.isSafeInteger(n);
exports.isPositiveAndFinite = isPositiveAndFinite;
function shuffle(alphabetChars, saltChars) {
    if (saltChars.length === 0) return alphabetChars;
    let integer;
    const transformed = [
        ...alphabetChars
    ];
    for(let i = transformed.length - 1, v = 0, p = 0; i > 0; i--, v++){
        v %= saltChars.length;
        // eslint-disable-next-line no-multi-assign
        p += integer = saltChars[v].codePointAt(0);
        const j = (integer + v + p) % i;
        // swap characters at positions i and j
        const a = transformed[i];
        const b = transformed[j];
        transformed[j] = a;
        transformed[i] = b;
    }
    return transformed;
}
exports.shuffle = shuffle;
const toAlphabet = (input, alphabetChars)=>{
    const id = [];
    let value = input;
    if (typeof value === "bigint") {
        const alphabetLength = BigInt(alphabetChars.length);
        do {
            id.unshift(alphabetChars[Number(value % alphabetLength)]);
            value /= alphabetLength;
        }while (value > BigInt(0));
    } else do {
        id.unshift(alphabetChars[value % alphabetChars.length]);
        value = Math.floor(value / alphabetChars.length);
    }while (value > 0);
    return id;
};
exports.toAlphabet = toAlphabet;
const fromAlphabet = (inputChars, alphabetChars)=>inputChars.reduce((carry, item)=>{
        const index = alphabetChars.indexOf(item);
        if (index === -1) throw new Error(`The provided ID (${inputChars.join("")}) is invalid, as it contains characters that do not exist in the alphabet (${alphabetChars.join("")})`);
        if (typeof carry === "bigint") return carry * BigInt(alphabetChars.length) + BigInt(index);
        const value = carry * alphabetChars.length + index;
        const isSafeValue = Number.isSafeInteger(value);
        if (isSafeValue) return value;
        throwIfBigIntNotAvailable(`Unable to decode the provided string, due to lack of support for BigInt numbers in the current environment`);
        return BigInt(carry) * BigInt(alphabetChars.length) + BigInt(index);
    }, 0);
exports.fromAlphabet = fromAlphabet;
const safeToParseNumberRegExp = /^\+?\d+$/;
const safeParseInt10 = (str)=>{
    if (!safeToParseNumberRegExp.test(str)) return Number.NaN;
    const int10 = Number.parseInt(str, 10);
    if (Number.isSafeInteger(int10)) return int10;
    throwIfBigIntNotAvailable("Unable to encode the provided BigInt string without loss of information due to lack of support for BigInt type in the current environment");
    return BigInt(str);
};
exports.safeParseInt10 = safeParseInt10;
const splitAtIntervalAndMap = (str, nth, map)=>Array.from({
        length: Math.ceil(str.length / nth)
    }, (_, index)=>map(str.slice(index * nth, (index + 1) * nth)));
exports.splitAtIntervalAndMap = splitAtIntervalAndMap;
const makeAnyOfCharsRegExp = (chars)=>new RegExp(chars.map((char)=>escapeRegExp(char))// we need to sort these from longest to shortest,
    // as they may contain multibyte unicode characters (these should come first)
    .sort((a, b)=>b.length - a.length).join("|"));
exports.makeAnyOfCharsRegExp = makeAnyOfCharsRegExp;
const makeAtLeastSomeCharRegExp = (chars)=>new RegExp(`^[${chars.map((char)=>escapeRegExp(char))// we need to sort these from longest to shortest,
    // as they may contain multibyte unicode characters (these should come first)
    .sort((a, b)=>b.length - a.length).join("")}]+$`);
exports.makeAtLeastSomeCharRegExp = makeAtLeastSomeCharRegExp;
const escapeRegExp = (text)=>text.replace(/[\s#$()*+,.?[\\\]^{|}-]/g, "\\$&");
const throwIfBigIntNotAvailable = (errorMessage = "BigInt is not available in this environment")=>{
    if (typeof BigInt !== "function") throw new TypeError(errorMessage);
};

},{}],"3SMsy":[function(require,module,exports) {
const _temp0 = require("d7aa420fa0672529");
const _temp1 = require("c5ba6ed2019567b1");
const _temp2 = require("7182094a5d60143");
const _temp3 = require("3dffb8b938475f5f");
const _temp4 = require("290574c82ce6882");
const _temp5 = require("ea0176c65b214cfa");
const _temp6 = require("5ed8a3d941201d85");
const _temp7 = require("5ce5f1d5cd62d9b9");
const _temp8 = require("8177e20d871698fa");
const _temp9 = require("62d718f25f2abb66");
const _temp10 = require("25f41b6458166756");
const _temp11 = require("8e75bb85bf9379d");
const _temp12 = require("a1c09e2142e05f3f");
const _temp13 = require("fd64d666b374af16");
const _temp14 = require("b116c58f86a19012");
const _temp15 = require("a325e70c805a7501");
const _temp16 = require("d3a8496be25a0c56");
const _temp17 = require("29f877a70e805aff");
const _temp18 = require("bff6758054972fa6");
const _temp19 = require("a13d49064356d0a");
const _temp20 = require("3210964ee1c0567c");
module.exports = {
    "assassin": _temp0,
    "avatar-frame": _temp1,
    "chip": _temp2,
    "crown": _temp3,
    "empty": _temp4,
    "jester": _temp5,
    "merlin": _temp6,
    "minion-1": _temp7,
    "minion-2": _temp8,
    "morgana": _temp9,
    "name-frame": _temp10,
    "percival": _temp11,
    "quest-fail": _temp12,
    "quest-success": _temp13,
    "servant-1": _temp14,
    "servant-2": _temp15,
    "servant-3": _temp16,
    "servant-4": _temp17,
    "shield": _temp18,
    "table": _temp19,
    "x-mark": _temp20
};

},{"d7aa420fa0672529":"1haN9","c5ba6ed2019567b1":"lQfT9","7182094a5d60143":"6fyry","3dffb8b938475f5f":"3v6Tu","290574c82ce6882":"eRSoa","ea0176c65b214cfa":"dZZzF","5ed8a3d941201d85":"itxsH","5ce5f1d5cd62d9b9":"1pY8a","8177e20d871698fa":"a0BeW","62d718f25f2abb66":"1aU65","25f41b6458166756":"jgAiT","8e75bb85bf9379d":"dsgO9","a1c09e2142e05f3f":"iuNtI","fd64d666b374af16":"fcJUQ","b116c58f86a19012":"dHQFs","a325e70c805a7501":"5nlim","d3a8496be25a0c56":"9pZBv","29f877a70e805aff":"hiaAG","bff6758054972fa6":"aUNdC","a13d49064356d0a":"8Zb57","3210964ee1c0567c":"adPK9"}],"1haN9":[function(require,module,exports) {
module.exports = require("f35b09fa7b60d576").getBundleURL("cBq6J") + "assassin.8b2d2c97.png" + "?" + Date.now();

},{"f35b09fa7b60d576":"lgJ39"}],"lgJ39":[function(require,module,exports) {
"use strict";
var bundleURL = {};
function getBundleURLCached(id) {
    var value = bundleURL[id];
    if (!value) {
        value = getBundleURL();
        bundleURL[id] = value;
    }
    return value;
}
function getBundleURL() {
    try {
        throw new Error();
    } catch (err) {
        var matches = ("" + err.stack).match(/(https?|file|ftp|(chrome|moz|safari-web)-extension):\/\/[^)\n]+/g);
        if (matches) // The first two stack frames will be this function and getBundleURLCached.
        // Use the 3rd one, which will be a runtime in the original bundle.
        return getBaseURL(matches[2]);
    }
    return "/";
}
function getBaseURL(url) {
    return ("" + url).replace(/^((?:https?|file|ftp|(chrome|moz|safari-web)-extension):\/\/.+)\/[^/]+$/, "$1") + "/";
}
// TODO: Replace uses with `new URL(url).origin` when ie11 is no longer supported.
function getOrigin(url) {
    var matches = ("" + url).match(/(https?|file|ftp|(chrome|moz|safari-web)-extension):\/\/[^/]+/);
    if (!matches) throw new Error("Origin not found");
    return matches[0];
}
exports.getBundleURL = getBundleURLCached;
exports.getBaseURL = getBaseURL;
exports.getOrigin = getOrigin;

},{}],"lQfT9":[function(require,module,exports) {
module.exports = require("ef540a708ec6c148").getBundleURL("cBq6J") + "avatar-frame.650d46bc.png" + "?" + Date.now();

},{"ef540a708ec6c148":"lgJ39"}],"6fyry":[function(require,module,exports) {
module.exports = require("7c9911ff8d7b4a3").getBundleURL("cBq6J") + "chip.6ae04c76.png" + "?" + Date.now();

},{"7c9911ff8d7b4a3":"lgJ39"}],"3v6Tu":[function(require,module,exports) {
module.exports = require("24ecfa4660fe6c63").getBundleURL("cBq6J") + "crown.77517138.png" + "?" + Date.now();

},{"24ecfa4660fe6c63":"lgJ39"}],"eRSoa":[function(require,module,exports) {
module.exports = require("ebc7a8088a58f9db").getBundleURL("cBq6J") + "empty.c38e2852.png" + "?" + Date.now();

},{"ebc7a8088a58f9db":"lgJ39"}],"dZZzF":[function(require,module,exports) {
module.exports = require("ed17113b71665331").getBundleURL("cBq6J") + "jester.95279bb4.png" + "?" + Date.now();

},{"ed17113b71665331":"lgJ39"}],"itxsH":[function(require,module,exports) {
module.exports = require("74b780ebbb2428d1").getBundleURL("cBq6J") + "merlin.e026da61.png" + "?" + Date.now();

},{"74b780ebbb2428d1":"lgJ39"}],"1pY8a":[function(require,module,exports) {
module.exports = require("3bb8a06bd218b45a").getBundleURL("cBq6J") + "minion-1.0f5c2a40.png" + "?" + Date.now();

},{"3bb8a06bd218b45a":"lgJ39"}],"a0BeW":[function(require,module,exports) {
module.exports = require("f0960a334253ce7").getBundleURL("cBq6J") + "minion-2.28049b1d.png" + "?" + Date.now();

},{"f0960a334253ce7":"lgJ39"}],"1aU65":[function(require,module,exports) {
module.exports = require("8d93d9eba7379d47").getBundleURL("cBq6J") + "morgana.78d119f8.png" + "?" + Date.now();

},{"8d93d9eba7379d47":"lgJ39"}],"jgAiT":[function(require,module,exports) {
module.exports = require("501d99e1d7705726").getBundleURL("cBq6J") + "name-frame.53794575.png" + "?" + Date.now();

},{"501d99e1d7705726":"lgJ39"}],"dsgO9":[function(require,module,exports) {
module.exports = require("e3fab281e8eb4f7c").getBundleURL("cBq6J") + "percival.82b06f54.png" + "?" + Date.now();

},{"e3fab281e8eb4f7c":"lgJ39"}],"iuNtI":[function(require,module,exports) {
module.exports = require("ea407c29f6d87ff7").getBundleURL("cBq6J") + "quest-fail.1efc503c.png" + "?" + Date.now();

},{"ea407c29f6d87ff7":"lgJ39"}],"fcJUQ":[function(require,module,exports) {
module.exports = require("497e4575bf4c552f").getBundleURL("cBq6J") + "quest-success.b2fa9549.png" + "?" + Date.now();

},{"497e4575bf4c552f":"lgJ39"}],"dHQFs":[function(require,module,exports) {
module.exports = require("b63574e05328f1a4").getBundleURL("cBq6J") + "servant-1.d6df869e.png" + "?" + Date.now();

},{"b63574e05328f1a4":"lgJ39"}],"5nlim":[function(require,module,exports) {
module.exports = require("f33786ccacb24ca3").getBundleURL("cBq6J") + "servant-2.497efb95.png" + "?" + Date.now();

},{"f33786ccacb24ca3":"lgJ39"}],"9pZBv":[function(require,module,exports) {
module.exports = require("e564a3e3b660e827").getBundleURL("cBq6J") + "servant-3.6ad1c693.png" + "?" + Date.now();

},{"e564a3e3b660e827":"lgJ39"}],"hiaAG":[function(require,module,exports) {
module.exports = require("e70073154b6934d4").getBundleURL("cBq6J") + "servant-4.8d375886.png" + "?" + Date.now();

},{"e70073154b6934d4":"lgJ39"}],"aUNdC":[function(require,module,exports) {
module.exports = require("745e244cd7e81b4b").getBundleURL("cBq6J") + "shield.6d23a96e.png" + "?" + Date.now();

},{"745e244cd7e81b4b":"lgJ39"}],"8Zb57":[function(require,module,exports) {
module.exports = require("9505ebe3bdd83313").getBundleURL("cBq6J") + "table.d9defdd0.png" + "?" + Date.now();

},{"9505ebe3bdd83313":"lgJ39"}],"adPK9":[function(require,module,exports) {
module.exports = require("f3c6b7dc0ca02d83").getBundleURL("cBq6J") + "x-mark.419654dd.png" + "?" + Date.now();

},{"f3c6b7dc0ca02d83":"lgJ39"}]},["856CK","b9zwu"], "b9zwu", "parcelRequiree8ef")

//# sourceMappingURL=spectate.7e3e74fd.js.map
